/* RYUED : Text Editor for All Computer with Escape Seakence */
/* Developed by Ryuji Miura , Copyright from 1998/6/20 */
/* kinput2 (at UNIX) support */
/* ver.1.04 : add EUC-code support (2002/3/1) */
/* ver.1.05 : add RedHat8.0 Konsole support part (2003/2/5) */
/* ver.1.06 : add RedHat8.0 gnome-term support part (2003/2/25) */
/* ver.1.07 : fix Undo bug for EUC Kanji (2005/2/18) */

/* Main Definitions */

#define	LOGO	"RYUED 1.07 euc"

#define	MSDOS	0	/* Support UNIX Type Keycode & Behavior */
#define	UNIX	1	/* Support UNIX Type Keycode & Behavior */
#define	EUCF	1	/* Switch to EUC-Mode (Otherwise ShiftJIS) */
#define	EOLF	3	/* Select EndMark for Line & File */
#define	HAFEP	0	/* Support ROM-KanjiFEP of NEC PC-98HA */
#define	IRIS	1	/* Disable CursorOn/Off EscapeSequence 
                                                    for IRIX, and so on */
#define	B16LXW	0	/* Support HITACHI B16LXW Keycord */
#define	REDHAT8	2	/* 1:Support RedHat8.0 Konsole for Cursor&BS&DEL */
			/* 2:Support RedHat8.0 gnome-term for Cursor&BS&DEL */

#define	DB(a)	    printf("\033[24;1HDB(%d) ",a)

/* Includes */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#if MSDOS
#include <malloc.h>
#include <dos.h>
#else
#include <unistd.h>
#endif

/* Definitons for Programing */

#define	CLS	    printf("\033[2J")
#define	CLSUP	    printf("\033[1J")
#define	LOCATE(x,y) printf("\033[%d;%dH",y+1,x+1)
#define	CLEARLINE   printf("\033[2K");
#define	R	"\033[7m"
#define	U	"\033[4m"
#define	N	"\033[0m"
#define	STATE(a)    printf(R"\033[%d;1H%-14s"N,hight,a)
#define	NOMAL(a)    (a!=0 && a!=28)
#define	BLANK(a)    (a==0 || a==28)
#define	TERMS(a)    ((a>='0'&&a<='9')||(a>='A'&&a<='Z')||(a>='a'&&a<='z'))

#if MSDOS
#define	KANJI(a)    ((a>=0x81 && a<=0x9f)||(a>=0xe0 && a<=0xfc))
#define	BUTTOMON    printf("\033[>1l")
#define	BUTTOMOFF   printf("\033[>1h")
#define	GETKEY	    (bdos(7,0,0)&255)
#define	PUT(a)	    putch(a)
#define	DATA	    char far
#define	ALLOC(a)    farmalloc((unsigned	long)a)
#define	FREE(a)	    farfree(a)
#else
#if EUCF==1
#define	KANJI(a)    (a<0)
#else
#define	KANJI(a)    ((a>=-127 && a<=-97)||(a>=-32 && a<=-4))
#endif
#define	BUTTOMON    ;
#define	BUTTOMOFF   ;
#define	GETKEY	    Getkey()
#define	PUT(a)	    putchar(a)
#define	DATA	    char
#define	ALLOC(a)    malloc((size_t)a)
#define	FREE(a)	    free(a)
int Getkey();
int Resetkey();
#endif

/* End Mark of Line and File */
#if EOLF==0
#define	LFPRINT	    PUT(31)
#define	EOFPRINT    PUT(29)
#elif EOLF==1
#define	LFPRINT	    printf("\033[5m/\033[0m");
#define	EOFPRINT    printf("\033[7m*\033[0m");
#elif EOLF==2
#define	LFPRINT	    printf("\033[5m\037\033[0m");
#define	EOFPRINT    printf("\033[7m*\033[0m");
#elif EOLF==3
#define	LFPRINT	    printf("\033[4m/\033[0m");
#define	EOFPRINT    printf("\033[7m*\033[0m");
#else
#define	LFPRINT	    printf(" ");
#define	EOFPRINT    printf("*");
#endif

#if HAFEP
#define	LOOKEY	    ((bdos(11,0,0)&255)||kanji>1)
#define	INPUT	    Kanji()
int Kanji();
extern int kanji;
#else
#define	LOOKEY	    (bdos(11,0,0)&255)
#define	INPUT	    GETKEY
#endif

#if !IRIS
#define	CURSORON    printf("\033[>5l")
#define	CURSOROFF   printf("\033[>5h")
#else
#define	CURSORON    ;
#define	CURSOROFF   ;
#endif

/* Numbers */

#define	LINEMAX	    16384
#define	BUFMAX	    16384
#define	WIDTH	    80
#define	UNDOMAX	    256

/* General Valiables */

DATA *dp[LINEMAX];
char cutbuf[BUFMAX];
int  line;
char file[10][256];
int  filep=0;
int  base;
int  curx,cury,prvx;
int  mrkx,mrky;
int  hight=24;
int  center=11;
int  roll=16;
int  tabl=8;
int  cutp=0;
int  skip=1;
int  linemax=LINEMAX;
char undobuf[UNDOMAX];
int  undop=0;
char searchs[256];
char searchl=0;
int  curxl[10];
int  curyl[10];
int  basel[10];
int  flags[10];
int  autotab=1;
int  pagestep=0;
int  unims[10];	/* The Flag of MS-DOS File edited on UNIX */



int View(void){
    int	i,j,c;
    
    LOCATE(WIDTH-1,hight-2);
    CLSUP;
    i=0;
    while(i<hight-1){
	LOCATE(0,i);
	if(pagestep>0){
	    if((i+base)%pagestep==0) printf(R);
	    else printf(N);
	    }
	j=0;
	while(j<WIDTH){
	    c=dp[i+base][j];
	    if(c==10){
		LFPRINT;
		break;
		}
	    if(c==26){
		EOFPRINT;
		break;
		}
	    if(c==9 || c==28) c=32;
	    PUT(c);
	    j++;
	    }
	i++;
	if(i+base>=line) break;
	}
    printf(N);
    
    return 0;
    }



int LinePrint(int y){
    int	i,j,c;
    
    LOCATE(0,y);
    CLEARLINE;
    i=base+y;
    if(i<line){
	if(pagestep>0) if(i%pagestep==0) printf(R);
	j=0;
	while(j<WIDTH){
	    c=dp[i][j];
	    if(c==10){
		LFPRINT;
		break;
		}
	    if(c==26){
		EOFPRINT;
		break;
		}
	    if(c==9 || c==28) c=32;
	    PUT(c);
	    j++;
	    }
	printf(N);
	}
    
    return 0;
    }



int Review(int f){
    int	y;
    
    if(f<0) for(y=cury;y<hight-1;y++) LinePrint(y);
    else for(y=cury;y<=f-base && y<hight-1;y++)	LinePrint(y);
    
    return 0;
    }



int GetString(char *title,char *buf){
    int	a,b,l;
    
    LOCATE(0,hight-2);
    CLEARLINE;
    l=strlen(title);
    if(l>0) printf(title);
    a=0;
    while(1){
	CURSORON;
	b=INPUT;
	CURSOROFF;
	if(b==27 || b==19 || b==18 || b==13) break;
	if(b==8	&& a>0){
	    a--;
	    if(KANJI(buf[a-1]))	a--;
	    LOCATE(a+l,hight-2);
	    PUT(32);
	    LOCATE(a+l,hight-2);
	    }
	if(b>=32){
	    LOCATE(a+l,hight-2);
	    buf[a]=b;
	    PUT(b);
	    a++;
#if !UNIX
	    while(LOOKEY){
		if(a>=70) break;
		b=INPUT;
		buf[a]=b;
		PUT(b);
		a++;
		}
#endif
	    if(a>=70) break;
	    }
	}
    if(b==27){
	buf[0]=0;
	a=-1;
	}
    else buf[a]=0;
    LinePrint(hight-2);
    
    return a;
    }



int CheckX(int x,int y){
    int	i,a;
    
    while(x>0){
	if(NOMAL(dp[y][x])) break;
	x--;
	}
    
    i=0;
    while(i<=x){
	a=dp[y][i];
	i++;
	if(KANJI(a)) i++;
	}
    i--;
    if(KANJI(a)) i--;
    
    return i;
    }



int CheckCury(int y){
    cury=y;
    if(cury>hight-4 || (cury<2 && base>0)){
	base+=cury-center;
	cury=center;
	if(base<0){
	    cury+=base;
	    base=0;
	    }
	View();
	}
    return 0;
    }



int AddLine(int	y){
    int	i;
    DATA *p;
    
    if(line>=linemax) return -1;
    p=dp[line];
    for(i=line;i>y;i--)	dp[i]=dp[i-1];
    line++;
    dp[y]=p;
    for(i=0;i<WIDTH;i++) dp[y][i]=0;
    
    return 0;
    }



int DelLine(int	y){
    int	i;
    DATA *p;
    
    p=dp[y];
    for(i=y;i<line-1;i++) dp[i]=dp[i+1];
    line--;
    dp[line]=p;
    
    return 0;
    }



int Load(void){
    FILE *fp;
    int	c,i;
    
    line=0;
    fp=fopen(file[filep],"r");
    if(fp==NULL){
	dp[0][0]=26;
	line=1;
	STATE("New File");
	return 0;
	}
    
    while(feof(fp)==0){
	i=0;
	while(i<WIDTH){
	    c=fgetc(fp);
#if UNIX
	    if(c==13){
		unims[filep]=1;
		continue;
		}
#endif
	    if(c<0) c=26;
	    if(c==9) dp[line][i]=32;
	    else dp[line][i]=c;
	    i++;
	    if(c==9){
		while(i%tabl!=0){
		    dp[line][i]=32;
		    i++;
		    }
		}
	    if(c==10 ||	c==26) break;
	    }
	while(i<WIDTH){
	    dp[line][i]=0;
	    i++;
	    }
	line++;
	if(line==linemax) break;
	}
    fclose(fp);
    
    return 0;
    }



int Save(void){
    int	a,b,c,d,e,i,j,k;
    FILE *fp;
#if UNIX
    char buf[256];
    
    sprintf(buf,"%s~",file[filep]);	/* Make backup file */
    fp=fopen(buf,"r");
    if(fp==NULL) rename(file[filep],buf);
    else fclose(fp);
#endif
    
    fp=fopen(file[filep],"w");
    if(fp==NULL) return	-1;
    c=0;				/* quotation flag */
    a=0;				/* current charactor */
    d=0;
    for(i=0;i<line;i++){
	b=0;				/* space counter */
	for(j=0;j<WIDTH;j++){
	    if(j%8==0 && b){
		fputc(9,fp);
		b=0;
		}
	    e=d;			/* previous2 charactor */
	    d=a;			/* previous charactor */
	    a=dp[i][j];
	    if(a=='*' && d=='/'	&& c==0) c=1;	/* check comment */
	    if(a=='/' && d=='*'	&& c==1) c=0;
	    if((a==34 || a==39)&&(d!='\\' || (d=='\\' && e=='\\'))){
                                        /* check quotation */
                if(c==0) c=a;
                else if(c==a) c=0;
                }
            switch(a){
              case 0: case 28:          /* skip non efect charactor */
                break;
              case 32:
                if(c==0 && autotab){    /* space -> tab convert */
                    b++;
                    break;
                    }
              default:
                if(b) for(k=0;k<b;k++) fputc(32,fp);
                b=0;
#if UNIX
                if(a==10 && unims[filep]!=0) fputc(13,fp);
#endif
                if(a!=26) fputc(a,fp);
                break;
                }
            if(d>15) d=0;
            if(a==26) break;
            }
        if(a==26) break;
        if(b) fputc(9,fp);
        }
    fclose(fp);
    return 0;
    }



int Status(void){
    int l;
    char buf[40];
#if UNIX
    char *name;
#endif
    
    LOCATE(0,hight-1);
    l=strlen(file[filep]);
#if UNIX
    l-=23;
    if(l<0) l=0;
    strcpy(buf,&file[filep][l]);
    buf[23]='\0';
    name=getlogin();
    if(pagestep) printf(R"%s : L %4d/%4d , C %2d , P %2d : %-8s : %-23s"N,
        LOGO,cury+base,line,curx,(cury+base)/pagestep,name,buf);
    else printf(R"%s : Line %4d/%4d , Corum %2d : %-8s : %-23s"N,
        LOGO,cury+base,line,curx,name,buf);
#else
    l-=34;
    if(l<0) l=0;
    strcpy(buf,&file[filep][l]);
    buf[34]='\0';
    if(pagestep) printf(R"%s : L %4d/%4d , C %2d , P %2d : %-34s"N,
           LOGO,cury+base,line,curx,(cury+base)/pagestep,buf);
    else printf(R"%s : Line %4d/%4d , Corum %2d : %-34s"N,
           LOGO,cury+base,line,curx,buf);
#endif
    return 0;
    }



int Inseart(int x0,int y0,int c){
    int a,f,x,y,xx,yy;
    
    x=x0;
    y=y0;
    while(1){   /* get x position of ret mark */
        a=dp[y][x];
        if(a==10 || a==26) break;
        x++;
        if(x>=WIDTH){
            x=0;
            y++;
            }
        }
    xx=x+c;     /* new position of retern mark */
    yy=y;
    f=xx/WIDTH;
    if(f>0){    /* if new line must be created */
        yy+=f;
        xx%=WIDTH;
        for(a=0;a<f;a++) AddLine(y+1);
        a=xx+1;
        while(a<WIDTH) dp[yy][a++]=0;
        f=-1;
        }
    else f=yy;
    while(y>y0 || (y==y0 && x>=x0)){
        dp[yy][xx]=dp[y][x];
        xx--;
        if(xx<0){
            xx=WIDTH-1;
            yy--;
            }
        x--;
        if(x<0){
            x=WIDTH-1;
            y--;
            }
        }
    
    return f;
    }



int Delete(int x,int y,int d){
    int a,b,c;
    
    a=x+d;                              /* position of delete end */
    b=y;
    while(a>=WIDTH){
        a-=WIDTH;
        b++;
        }
    while(1){
        c=dp[b][a];
        dp[y][x]=c;
        if(c==10 || c==26) break;
        x++;
        if(x>=WIDTH){
            x=0;
            y++;
            }
        a++;
        if(a>=WIDTH){
            a=0;
            b++;
            }
        }
    if(b>y){
        for(a=0;a<b-y;a++) DelLine(y+1);
        b=-1;
        }
    if(x<WIDTH-1) for(a=x+1;a<WIDTH;a++) dp[y][a]=0;
    return b;
    }



int CutCopy(int m){
    int a,b,aa,bb,x,y,d,i;
    
    x=curx;
    y=cury+base;
    if(mrky==y && x==mrkx) return 0;
    cutp=0;
    a=mrkx;
    b=mrky;
    if(y<mrky || (y==mrky && x<mrkx)){
        a=x;
        b=y;
        x=mrkx;
        y=mrky;
        }
    aa=a;
    bb=b;
    while(b<=y){
        while((a<WIDTH && b<y)||(a<x && b==y)){
            if(cutp>=BUFMAX) break;
            d=dp[b][a];
            a++;
            if(d==0 || d==28) continue;
            cutbuf[cutp]=d;
            cutp++;
            }
        if(cutp>=BUFMAX) break;
        a=0;
        b++;
        }
    if(cutp>=BUFMAX) return 0;
    if(m){
        flags[filep]=1;
        curx=aa;
        CheckCury(bb-base);
        if(x==0 && aa==0 && y!=bb){
            a=y-bb;
            for(i=0;i<a;i++) DelLine(bb);
            Review(-1);
            }
        else{
            d=(x-aa)+(y-bb)*WIDTH;
            Review(Delete(aa,bb,d));
            }
        }
    return 0;
    }



int Paste(void){
    int a,b,d,f,aa,bb,x,y,i;
    
    if(cutp<1) return 0;
    flags[filep]=1;
    y=cury+base;
    f=0;
    aa=0;
    for(b=cutp-1;b>=0;b--){
        d=cutbuf[b];
        if(d!=0 && d!=28) aa++;
        if(d==10){
            aa--;
            f=-1;
            if(curx==0) AddLine(y);
            else{
                AddLine(y+1);
                for(i=curx;i<WIDTH;i++){
                    dp[y+1][i]=dp[y][i];
                    dp[y][i]=0;
                    }
                }
            dp[y][curx]=10;
            if(curx>aa) Delete(aa,y+1,curx-aa);
            if(curx<aa) Inseart(curx,y+1,aa-curx);
            if(aa>0){
                x=0;
                bb=y+1;
                for(i=1;i<=aa;i++){
                    dp[bb][x]=cutbuf[b+i];
                    x++;
                    if(x>=WIDTH){
                        x=0;
                        bb++;
                        }
                    }
                aa=0;
                }
            }
        }
    if(aa>0){
        a=Inseart(curx,y,aa);
        if((f>=0 && a>f) || a<0) f=a;
        x=curx;
        for(i=0;i<aa;i++){
            dp[y][x]=cutbuf[i];
            x++;
            if(x>=WIDTH){
                x=0;
                y++;
                if(y>=linemax) break;
                }
            }
        }
    Review(f);
    return 0;
    }



int DelAfter(void){
    int a,b,d,x,y,aa;
    
    x=curx;
    y=cury+base;
    aa=0;
    
    /* count number of delete letters */
    while(1){
        b=dp[y][x];
        if(b==10 || b==26) break;
        aa++;
        x++;
        if(x>=WIDTH){
            x=0;
            y++;
            if(y>=line) break;
            }
        }
    
    if(aa<1){ /* the case for no letter in line */
        if(b!=26){
            if(cutp<BUFMAX){
                cutbuf[cutp]=10;
                cutp++;
                }
            if(curx==0){
                DelLine(y);
                Review(-1);
                }
            else Review(Delete(curx,cury+base,WIDTH-curx));
            }
        }
    else{ /* the case for some letter in line */
        a=curx;
        b=cury+base;
        while(b<=y){
            while((a<WIDTH && b<y)||(a<x && b==y)){
                if(cutp>=BUFMAX) break;
                d=dp[b][a];
                a++;
                if(d==0 || d==28) continue;
                cutbuf[cutp]=d;
                cutp++;
                }
            if(cutp>=BUFMAX) break;
            a=0;
            b++;
            }
        Review(Delete(curx,cury+base,aa));
        }
    
    return 0;
    }



int Search(int c){
    int b,aa,bb,x,y;
    
    /* searching */
    b=0;
    x=curx;
    y=cury+base;
    while(y<line && y>=0 && b<searchl){
        do{
            if(c>0){
                x++;
                if(x>=WIDTH){
                    x=0;
                    y++;
                    if(y>=line) break;
                    }
                }
            else{
                x--;
                if(x<0){
                    x=WIDTH-1;
                    y--;
                    if(y<0) break;
                    }
                }
            }while(dp[y][x]!=searchs[0]);
        if(y>=line || y<0) break;
        aa=x;
        bb=y;
        if(searchl==1) break;
        b=0;
        while(b<searchl){
            if(dp[y][x]>=32){
                if(dp[y][x]!=searchs[b]) break;
                b++;
                }
            x++;
            if(x>=WIDTH){
                x=0;
                y++;
                if(y>=line) break;
                }
            }
        x=aa;
        y=bb;
        }
    if(y>=line || y<0) return -1;
    curx=aa;
    if(c!=2) CheckCury(bb-base);
    else{
        cury=bb-base;
        if(cury>hight-4 || (cury<2 && base>0)){
            base+=cury-center;
            cury=center;
            if(base<0){
                cury+=base;
                base=0;
                }
            }
        }
    
    return 0;
    }



int Option(int p){
    int a,b,c,d,e,i,x,y,ef;
    char buf[256],buf2[256];
    
    ef=1;
    switch(p){
      case 'r': case 'R': case 18:              /* replace */
        a=GetString("Replace from : ",buf);     /* input search string */
        if(a<0) break;
        if(a>0){
            strcpy(searchs,buf);
            searchl=a;
            }
        a=searchl;
        if(a==0) break;
        b=GetString("Replace to : ",buf2);      /* input areplace string */
        if(b<0) break;
        c=b-a;
        d='n';
        e=-1;
        while(Search((d=='a'?2:1))==0){
            if(d!='a'){
                LOCATE(0,hight-2);
                printf("Replace ? (y/n/all) ");
                LOCATE(curx,cury);
                d=0;
                CURSORON;
                while(d!='y' && d!='n' && d!='a' && d!=27) d=GETKEY;
                CURSOROFF;
                }
            if(d==27) break;
            if(d=='n') continue;
            flags[filep]=1;
            x=curx;
            y=cury+base;
            if(c>0) e=Inseart(x,y,c);
            if(c<0) e=Delete(x,y,-c);
            if(b>0){
                for(i=0;i<b;i++){
                    dp[y][x]=buf2[i];
                    x++;
                    if(x>=WIDTH){
                        x=0;
                        y++;
                        }
                    }
                }
            if(d=='y') Review(e);
            }
        if(d=='a') View();
        else LinePrint(hight-2);
        break;
      case 'i': case 'I': case 9:       /* autotab switch */
        autotab=1-autotab;
        LOCATE(0,hight-2);
        if(autotab) printf("Autotab Seted");
        else printf("Autotab Reseted");
        break;
      case 'p': case 'P': case 16:      /* page step set */
        a=GetString("Set Page Step > ",buf);
        if(a>0){
            pagestep=atoi(buf);
            if(pagestep<0) pagestep=0;
            }
        Status();
        break;
      case 's': case 'S': case 19:      /* Save File */
        Save();
        flags[filep]=0;
        break;
      case 'c': case 'C': case 3:       /* Close File */
        if(dp[0][0]!=26 && flags[filep]){
            LOCATE(0,hight-2);
            CLEARLINE;
            printf("Save %s ?(y/n) ",file[filep]);
            do{
                a=GETKEY;
                }while(a!='n' && a!='N' && a!='y' && a!='Y' && a!=27);
            if(a=='y' || a=='Y'){
                LOCATE(0,hight-2);
                printf("Now Saving file...   ");
                Save();
                }
            if(a==27){
                LinePrint(hight-2);
                break;
                }
            }
        file[filep][0]=0;
        unims[filep]=0;
        curxl[filep]=0;
        curyl[filep]=0;
        basel[filep]=0;
        flags[filep]=0;
        for(i=0;i<10;i++) if(strlen(file[i])>0) break;
        if(i>=10) ef=0;
        else{
            filep=i;
            Load();
            curx=curxl[filep];
            cury=curyl[filep];
            base=basel[filep];
            View();
            Status();
            }
        break;
      case 'a': case 'A': case 1:       /* Rename save */
        a=GetString("Write File Name > ",buf);
        if(a>0){
            strcpy(file[filep],buf);
            Save();
            flags[filep]=0;
            Status();
            }
        break;
      case 'o': case 'O': case 15:      /* load & entry file */
      case 'f': case 'F':
        for(i=0;i<10;i++) if(strlen(file[i])==0) break;
        if(i>=10){
            STATE("No more file");
            break;
            }
        a=GetString("Load File Name > ",buf);
        if(a>0){
            a='y';
            if(dp[0][0]!=26 && flags[filep]){
                LOCATE(0,hight-2);
                CLEARLINE;
                printf("Save %s ?(y/n) ",file[filep]);
                do{
                    a=GETKEY;
                    }while(a!='n' && a!='N' && a!='y' && a!='Y' && a!=27);
                if(a=='y' || a=='Y'){
                    LOCATE(0,hight-2);
                    printf("Now Saving file...   ");
                    Save();
                    }
                }
            if(a=='y' || a=='Y'){
                flags[filep]=0;
                curxl[filep]=curx;
                curyl[filep]=cury;
                basel[filep]=base;
                filep=i;
                strcpy(file[i],buf);
                Load();
                curx=0;
                cury=0;
                base=0;
                flags[filep]=0;
                Status();
                }
            View();
            }
        break;
      case 'l': case 'L': case 12:      /* file list and switch */
        y=hight-11;
        for(i=0;i<10;i++){
            LOCATE(0,y);
            CLEARLINE;
            if(flags[i]) printf("No %d * %s",i,file[i]);
            else printf("No %d . %s",i,file[i]);
            y++;
            }
        CURSORON;
        a=GETKEY;
        CURSOROFF;
        b=a-'0';
        if(b>=0 && b<=9 && b!=filep) if(strlen(file[b])>0){
            a='y';
            if(dp[0][0]!=26 && flags[filep]){
                LOCATE(0,hight-2);
                CLEARLINE;
                printf("Save %s ?(y/n) ",file[filep]);
                do{
                    a=GETKEY;
                    }while(a!='n' && a!='N' && a!='y' && a!='Y' && a!=27);
                if(a=='y' || a=='Y'){
                    LOCATE(0,hight-2);
                    printf("Now Saving file...   ");
                    Save();
                    }
                }
            if(a=='y' || a=='Y'){
                flags[filep]=0;
                curxl[filep]=curx;
                curyl[filep]=cury;
                basel[filep]=base;
                filep=b;
                Load();
                curx=curxl[filep];
                cury=curyl[filep];
                base=basel[filep];
                Status();
                }
            }
        View();
        break;
      case 'j': case 'J': case 10:      /* Mark Jamp */
        curx=mrkx;
        base=mrky-center;
        cury=center;
        if(base<0){
            cury+=base;
            base=0;
            }
        View();
        break;
      case 'm': case 'M': case 13:      /* Search KAKKO (non Japanese) */
        x=curx;
        y=cury+base;
        a=dp[y][x];     /* current charactor */
        b=0;            /* nest counter */
        c=0;            /* quotation flag */
        d=0;            /* previous charactor */
        if(a==')' || a==']' || a=='}') while(b>=0){
            x--;
            if(x<0){
                x=WIDTH-1;
                y--;
                if(y<0) break;
                }
            a=dp[y][x];
            if(a=='\\' && x>1) if(dp[y][x-1]!='\\') switch(c){
              case 1: if(d=='"') c=0; break;
              case 2: if(d=='\'') c=0; break;
              case 0:
                if(d=='"') c=1;
                if(d=='\'') c=2;
                break;
                }
            if(a=='"') switch(c){
              case 0: c=1; break;
              case 1: c=0; break;
                }
            if(a=='\'') switch(c){
              case 0: c=2; break;
              case 2: c=0; break;
                }
            if(c==0){
                if(a==')' || a==']' || a=='}') b++;
                if(a=='(' || a=='[' || a=='{') b--;
                }
            d=a;
            }
        else while(b>=0){
            x++;
            if(x>=WIDTH){
                x=0;
                y++;
                if(y>=line) break;
                }
            a=dp[y][x];
            if(d!='\\'){
                if(a=='"') switch(c){
                  case 0: c=1; break;
                  case 1: c=0; break;
                    }
                if(a=='\'') switch(c){
                  case 0: c=2; break;
                  case 2: c=0; break;
                    }
                }
            else if(a=='\\') a=0;
	    if(c==0){
		if(a=='(' || a=='[' || a=='{') b++;
		if(a==')' || a==']' || a=='}') b--;
		}
	    d=a;
	    }
	if(b==-1){
	    curx=x;
	    cury=y-base;
	    if(cury>=hight-3 ||	( cury<2 && base>0 )){
		base=y-center;
		cury=center;
		if(base<0){
		    cury+=base;
		    base=0;
		    }
		View();
		}
	    }
	else{
	    STATE("Can't find");
	    }
	break;
      case 'u':	case 'U': case 21:	/* unflag */
	flags[filep]=0;
	STATE("unflagd");
	break;
      case 'k':	case 'K':		/* space skip */
	skip=1-skip;
	break;
      case 6:				/* word forward */
	x=curx;
	y=cury+base;
	while(!TERMS(dp[y][x])){
	    x++;
	    if(x>=WIDTH){
		y++;
		x=0;
		}
	    }
	while(TERMS(dp[y][x])){
	    x++;
	    if(x>=WIDTH){
		y++;
		x=0;
		}
	    }
	curx=x;
	CheckCury(y-base);
	break;
      case 2:				/* word backward */
	x=curx;
	y=cury+base;
	do{
	    x--;
	    if(x<0){
		if(y<=0) break;
		y--;
		x=WIDTH-1;
		}
	    }while(!TERMS(dp[y][x]));
	do{
	    curx=x;
	    cury=y;
	    x--;
	    if(x<0){
		if(y<=0) break;
		y--;
		x=WIDTH-1;
		}
	    }while(TERMS(dp[y][x]));
	CheckCury(cury-base);
	break;
      case 4:				/* tab delete */
	y=cury+base;
	x=curx;
	a=0;
	while(x<WIDTH-1){
	    if(dp[y][x]==32){
		a++;
		x++;
		}
	    else if(dp[y][x]==-127 && dp[y][x+1]==0x40){
		a+=2;
		x+=2;
		}
	    else break;
	    }
	if(a>0){
	    Review(Delete(curx,y,a));
	    flags[filep]=1;
	    }
	break;
      case 8:				/* tab backspace */
	y=cury+base;
	x=curx;
	a=0;
	while(x>0){
		if(dp[y][x-1]==32){
		a++;
		x--;
		}
	    else if(x<2) break;
	    else if(dp[y][x-2]==-127 &&	dp[y][x-1]==0x40){
		a+=2;
		x-=2;
		}
	    else break;
	    }
	if(a>0){
	    curx=x;
	    Review(Delete(curx,y,a));
	    flags[filep]=1;
	    }
	break;
      case 11:				/* Delete Before */
	if(curx<=0) break;
	y=cury+base;
	for(i=0;i<curx;i++) cutbuf[cutp++]=dp[y][i];
	Review(Delete(0,y,curx));
	flags[filep]=1;
	curx=0;
	break;
      default: break;
	}
    
    return ef;
    }



int main(int optn,char *optc[]){
    int	ef;
    int	i,a,b,c,d,f,x,y,cc,p,kf;
    char buf[256];
    
    /* START UP -------------------------------------------------------------*/
    if(optn<2){
	puts(LOGO" : Usage filename [-options]");
	puts(" -h(number) : hight of screen (default 24)");
	puts(" -t(number) : tab length (default 8)");
	puts(" -s         : skip space off (default on)");
	printf(" -l(number) : maximum line number (default %d)\n",LINEMAX);
	puts(" -a         : auto TAB save off (default on)");
	puts(" -p(number) : page step (default 0 : none)");
	return -1;
	}
    strcpy(file[0],"temp.txt");
    for(i=1;i<10;i++){
	file[i][0]=0;
	unims[i]=0;
	}
    f=0;
    for(i=1;i<optn;i++){
	if(optc[i][0]=='-') switch(optc[i][1]){
	  case 'h':
	    hight=atoi(&optc[i][2]);
	    if(hight<10){
		puts("Hight is too short! Set more than 10 line.");
		return -1;
		}
	    center=(hight-2)/2;
	    roll=hight*2/3;
	    break;
	  case 't':
	    tabl=atoi(&optc[i][2]);
	    if(tabl<2 || tabl>40){
		puts("TAB has worng length! Please set from 2 to 40.");
		return -1;
		}
	    break;
	  case 's':
	    skip=0;
	    break;
	  case 'l':
	    linemax=atoi(&optc[i][2]);
	    if(linemax<1024 || linemax>LINEMAX){
		printf("Worng numbar of maximum line! "
		    "Set this value from 1024 to %d.\n",LINEMAX);
		return -1;
		}
	    break;
	  case 'a':
	    autotab=0;
	    break;
	  case 'p':
	    pagestep=atoi(&optc[i][2]);
	    if(pagestep<0){
		puts("Wrong number of page step!");
		return -1;
		}
	    break;
	    }
	else strcpy(file[f],optc[i]);
	}
    for(i=0;i<linemax;i++)
	if((dp[i]=ALLOC(WIDTH))==NULL){
	    printf("Can't allocate memory for %d line!\n",linemax);
	    printf("Now available line is %d only.\n",i);
	    printf("Push return key to continue starting.");
	    getchar();
	    linemax=i;
	    break;
	    }
    
    /* CLEAR SETTINGS -------------------------------------------------------*/
    BUTTOMON;
    CLS;
    CURSOROFF;
    Status();
    base=0;
    ef=1;
    c=0;
    curx=0;
    cury=0;
    prvx=0;
    mrkx=0;
    mrky=0;
    kf=0;
    searchl=0;
    filep=0;
    Load();
    View();
    for(i=0;i<UNDOMAX;i++) undobuf[i]=0;
    for(i=0;i<10;i++){
	curxl[i]=0;
	curyl[i]=0;
	basel[i]=0;
	flags[i]=0;
	}
    
    /* NOMAL PROCESS LOOP ---------------------------------------------------*/
    while(ef){
	if(pagestep==0){
	    LOCATE(22,hight-1);
	    if(flags[filep])
		printf(R"%4d/%4d * Corum %2d"N,cury+base,line,curx);
	    else
		printf(R"%4d/%4d , Corum %2d"N,cury+base,line,curx);
	    }
	else{
	    LOCATE(17,hight-1);
	    if(flags[filep])
		printf(R"L %4d/%4d * C %2d * P %2d"N,
		    cury+base,line,curx,(cury+base)/pagestep);
	    else
		printf(R"L %4d/%4d , C %2d , P %2d"N,
		    cury+base,line,curx,(cury+base)/pagestep);
	    }
	LOCATE(curx,cury);
	d=c;
	CURSORON;
	c=INPUT;
	if(c==27){ /* ESC : option */
	    p=GETKEY;
	    switch(p){
#if UNIX
		/* UNIXs cursor & Page up & down key */
	      case '[':
#if REDHAT8
	      case 'O':	/* for RedHast 8.0 Konsole & gnome-term */
#endif
		a=GETKEY;
		switch(a){
		  case 'A': c=16; break; /* Cursor Up */
		  case 'B': c=14; break; /* Cursor Down */
		  case 'C': c=6; break;	/* Cursor Left */
		  case 'D': c=2; break;	/* Cursor Right */
		  case 'H': c=1; break;	/* HOME key of IRIX & RH8-Konsole */
		  case 'F': c=5; break;	/* END key of RH8-Konsole */
		  case 0: c=1; break; /* HOME&END of Linux and HOME of HPUX */
		  case '0': case '1': case '2':	case '3': case '4':
		  case '5': case '6': case '7':	case '8': case '9':
		    b=a-'0';
		    while(1){
			a=GETKEY;
			if(a==126 || a=='q') break;
			b*=10;
			b+=a-'0';
			}
		    switch(b){
		      case 3: c=4; break;   /* DEL key of RedHat8.0-Konsole */
		      case 4: c=21; break;  /* END key of HPUX */
		      case 5: c=7; break;   /* PageUp key of HPUX */
		      case 6: c=22; break;  /* PageDown key of HPUX */
		      case 146:	c=21; break;/* END Key of IRIX */
		      case 150:	c=7; break; /* PageUp key of IRIX */
		      case 154:	c=22; break;/* PageDown key of IRIX */
		      default: c=-1; break;
			}
		    break;
		  default: c=-1; break;
		    }
		break;
#elif MSDOS
		/* Cursor Key For Some MS-DOS Machine (ex. PC-9801) */
	      case '\\': c=6; break; /* Forward */
              case ']': c=2; break; /* Backward */
              case '^': c=16; break; /* Previous Line */
              case '_': c=14; break; /* Next Line */
#endif
                /* Keep Compatibility to Emacs */
              case 'w': case 'W': c=17; break; /* Copy */
              case 'v': case 'V': c=7; break; /* Roll Down */
                }
            }
        else if(d==26 || d==0){
            STATE(LOGO);
            }
        CURSOROFF;
#if REDHAT8==1
        if(c==127) c=8; /* for RedHat 8.0 Konsole (KDE) */
#elif UNIX
        if(c==127) c=4; /* for All Unix Environment including Linux */
#endif
        y=cury+base;
        switch(c){
          case 1: /* ^a : line top */
            curx=0;
            break;
          case 5: /* ^e : line end */
            curx=CheckX(WIDTH-1,y);
            break;
          case 6: /* ^f : forward */
#if B16LXW
          case 28:
#endif
            a=dp[y][curx];
            if(a==26) break;
            curx++;
            if(KANJI(a)) curx++;
            if(skip && a==32) while(curx<WIDTH-1){
                if(dp[y][curx]!=32) break;
                curx++;
                }
            while(curx<WIDTH)
                if(dp[y][curx]==28) curx++;
                else break;
            if(curx<WIDTH){
                if(dp[y][curx]!=0) break;
                curx=0;
                }
            else curx-=WIDTH;
            prvx=curx;
          case 14: /* ^n : next line */
#if B16LXW
          case 31:
#endif
            if(y>=line-1) break;
            CheckCury(cury+1);
            curx=CheckX(prvx,cury+base);
            break;
          case 2: /* ^b : backward */
#if B16LXW
          case 29:
#endif
            if(curx==0 && y==0) break;
            if(curx>0){
                curx=CheckX(curx-1,y);
                if(skip && dp[y][curx]==32) while(curx>0){
                    if(dp[y][curx-1]!=32) break;
                    curx--;
                    }
                break;
                }
            curx=WIDTH-1;
            prvx=curx;
          case 16: /* ^p : previous line */
#if B16LXW
          case 30:
#endif
            if(y==0) break;
            CheckCury(cury-1);
            curx=CheckX(prvx,cury+base);
            break;
          case 22: /* ^v : roll up */
            if(base+roll>=line) break;
            base+=roll;
            if(cury+base>=line) cury=line-base-1;
            if(cury<2){
                base-=center-cury;
                cury=center;
                }
            curx=CheckX(prvx,cury+base);
            View();
            break;
          case 7: /* ^g : roll down */
            if(base==0) break;
            base-=roll;
            if(base<0) base=0;
            curx=CheckX(prvx,cury+base);
            View();
            break;
          case 20: /* ^t : top of text */
            base=0;
            curx=0;
            cury=0;
            View();
            break;
          case 15: /* ^o : buttom of text */
            base=line-hight+3;
            if(base<0) base=0;
            cury=line-base-1;
            curx=0;
            View();
            break;
          case 12: /* ^l : center */
            base=y-center;
            if(base<0){
                cury=center+base;
                base=0;
                }
            else cury=center;
            View();
            break;
          case 10: /* ^j : go to line */
            a=GetString("Line No. > ",buf);
            if(a<1) break;
            b=atoi(buf);
            if(b<0) b=0;
            if(b>=line) b=line-1;
            base=b-center;
            if(base<0) base=0;
            cury=b-base;
            curx=CheckX(curx,b);
            View();
            break;
          case 8: /* ^h : backspace */
            if(curx==0 && y==0) break;
            flags[filep]=1;
            x=curx-1;
            if(x<0){
                x=WIDTH-1;
                y--;
                }
            b=CheckX(x,y);
            curx=b;
            d=dp[y][b];
            undobuf[undop++]=d;
            undobuf[undop++]=8;
            if(undop>=UNDOMAX) undop=0;
            if(KANJI(d)){
                if(b+1>=WIDTH) undobuf[undop++]=dp[y+1][0];
                else undobuf[undop++]=dp[y][b+1];
                undobuf[undop++]=2;
                if(undop>=UNDOMAX) undop=0;
                }
            CheckCury(y-base);
            Review(Delete(b,y,x-b+1));
            break;
          case 4: /* ^d : delete */
            x=curx;
            b=dp[y][x];
            if(b==26) break;
            flags[filep]=1;
            undobuf[undop++]=b;
            undobuf[undop++]=4;
            if(undop>=UNDOMAX) undop=0;
            if(KANJI(b)){
                if(x+1>=WIDTH) undobuf[undop++]=dp[y+1][0];
                else undobuf[undop++]=dp[y][x+1];
                undobuf[undop++]=2;
                if(undop>=UNDOMAX) undop=0;
                a=2;
                }
            else{
                a=0;
                do{
                    a++;
                    x++;
                    if(x>=WIDTH){
                        x=0;
                        y++;
                        }
                    }while(BLANK(dp[y][x]));
                }
            Review(Delete(curx,cury+base,a));
            break;
          case 13: /* ^m : return */
            if(line>=linemax) break;
            flags[filep]=1;
            y++;
            AddLine(y);
            for(i=curx;i<WIDTH;i++){
                dp[y][i]=dp[y-1][i];
                dp[y-1][i]=0;
                }
            dp[y-1][curx]=10;
            if(curx>0) Delete(0,y,curx);
            Review(-1);
            curx=0;
            CheckCury(cury+1);
            break;
          case 0: /* ^@ & ^SPC : marked */
          case 26: /* ^z : marked */
            mrkx=curx;
            mrky=y;
            STATE("Marked");
            break;
          case 17: /* ^q : copy */
            CutCopy(0);
            break;
          case 23: /* ^w : cut */
            CutCopy(1);
            break;
          case 25: /* ^y : paste (Not clear buffer) */
            Paste();
            break;
          case 9: /* ^i : TAB */
            flags[filep]=1;
            x=curx;
            b=4-x%4;
            a=Inseart(x,y,b);
            for(i=0;i<b;i++){
                dp[y][x]=32;
                x++;
                }
            Review(a);
            curx+=b;
            if(curx>=WIDTH){
                curx=80;
                CheckCury(cury+1);
                }
            break;
          case 19: /* ^s : search */
          case 18: /* ^r : back search */
            a=GetString("Search : ",buf);       /* input search string */
            if(a<0) break;
            if(a>0){
                strncpy(searchs,buf,a);
                searchl=a;
                }
            else if(searchl==0) break;
            if(c==19) Search(1);
            else Search(-1);
            break;
          case 11: /* ^k : delete after */
            flags[filep]=1;
            if(kf==0) cutp=0;
            DelAfter();
            kf=1;
            break;
          case 21: /* ^u : undo delete or backspace */
            if(undop==0) a=undobuf[UNDOMAX-1];
            else a=undobuf[undop-1];
            if(a==0) break;
            flags[filep]=1;
            undop-=2;
            if(undop<0) undop=UNDOMAX-2;
            d=0;
            if(a==2){ /* kanji */
                d=undobuf[undop];
                undobuf[undop]=0;
                undobuf[undop+1]=0;
                undop-=2;
                if(undop<0) undop=UNDOMAX-2;
                a=undobuf[undop+1];
                }
            x=curx;
            if(y==linemax-1 || line==linemax) break;
            b=undobuf[undop];
            undobuf[undop]=0;
            undobuf[undop+1]=0;
            if(b==10){
                y++;
                AddLine(y);
                for(i=x;i<WIDTH;i++){
                    dp[y][i]=dp[y-1][i];
                    dp[y-1][i]=0;
                    }
                dp[y-1][x]=10;
                if(x>0) Delete(0,y,x);
                Review(-1);
                x=0;
                }
            else{
                f=Inseart(x,y,1);
                dp[y][x]=b;
                x++;
                if(x>=WIDTH){
                    x=0;
                    y++;
                    }
                if(d!=0){
                    b=Inseart(x,y,1);
                    if(f>=0) if(b<0 || b>f) f=b;
                    dp[y][x]=d;
                    x++;
                    if(x+1>=WIDTH){
                        x=0;
                        y++;
                        }
                    }
                Review(f);
                }
            if(a==8){
                curx=CheckX(x,y);
                CheckCury(y-base);
                }
            break;
          case 24: /* ^x : options */
            STATE("[Ctrl-x]-");
            CURSORON;
            p=GETKEY;
            CURSOROFF;
            STATE(LOGO);
          case 27: /* ESC : options */
            ef=Option(p);
            break;
          case 3: /* ^c : forced stop */
            STATE("Ready?(y/n)");
            CURSORON;
            cc=GETKEY;
            CURSOROFF;
            if(cc=='y' || cc=='Y') ef=0;
            else STATE(LOGO);
            break;
          default: /* Inseart Input Strings */
            if(c<32) break;
            flags[filep]=1;
            x=curx;
            y=cury+base;
            f=Inseart(x,y,1);
            dp[y][x]=c;
            x++;
            if(x>=WIDTH){
                x=0;
                y++;
                }
#if !UNIX
            while(LOOKEY){
                c=INPUT;
                a=Inseart(x,y,1);
                dp[y][x]=c;
                if((a>f && f>=0)||a<0) f=a;
                x++;
                if(x>=WIDTH){
                    x=0;
                    y++;
                    }
                }
#endif
            Review(f);
            curx=x;
            CheckCury(y-base);
            break;
            }
        if(c!=16 && c!=14 && c!=22 && c!=7) prvx=curx;
        if(c!=11) kf=0;
        }
    
/*
#if MSDOS
    qsort(dp,linemax,sizeof(DATA),strcmp);
#endif
*/
#if UNIX
    Resetkey();
#endif
    for(i=linemax-1;i>=0;i--) FREE(dp[i]);
    CLS;
    LOCATE(0,0);
    CURSORON;
    BUTTOMON;
    return 0;
    }



